﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Deklaracja ZUS NP-7</title>
		<script runat="server">

        public class PrnParams : Soneta.Business.ContextBase {
            public readonly Nieobecnosc Nieobecność;
            public readonly ArrayList Nieobecności = new ArrayList();

            void LoadNieobecnosci() {
                Nieobecności.Add(Nieobecność);

                KalkulatorPracy kal = new KalkulatorPracy(Nieobecność.Pracownik);
                ArrayList lst = new ArrayList((ICollection)kal.Nieobecnosci(new FromTo(Date.MinValue, Nieobecność.Okres.From - 1), true));
                lst.Reverse();
                INieobecnosc prev = Nieobecność;
                foreach (INieobecnosc n in lst)
                    if (n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS)
                        if (Kontynuacja(prev, n)) {
                            Nieobecności.Add(n);
                            prev = n;
                        }
                        else
                            break;

                Nieobecności.Reverse();
                Początek = prev.Okres.From;
            }

            bool Kontynuacja(INieobecnosc current, INieobecnosc prev) {
                YearMonth cm = new YearMonth(current.Okres.From);
                YearMonth pm = new YearMonth(prev.Okres.To);

                int c = cm - pm;
                c -= 1;

                return c < 3;//Podstawę przeliczamy jeżeli pomiędzy końcem poprzedniej a początkiem 
                //nastepnej nieobecności ZUS muszą są co najmniej 3 pełne miesiące kalendarzoe
            }

            public FromTo OkresZatrudnienia() {
                if (początek == Date.Empty)
                    return FromTo.Empty;
                FromTo okres = Nieobecność.Pracownik[początek].Etat.OkresZatrudnienia;
                if (okres.From.Day > 1)
                    okres *= new FromTo((new YearMonth(okres.From) + 1).FirstDay, Date.MaxValue);
                return okres;
            }

            public FromTo OkresZatrudnieniaRok() {
                return OkresZatrudnienia() * new FromTo(new Date(Nieobecność.Okres.From.Year, 1, 1), Date.MaxValue);
            }

            public PrnParams(Context context) : base(context) {
                Nieobecność = (Nieobecnosc)context[typeof(Nieobecnosc)];
                LoadNieobecnosci();
            }

            Date początek;
            [Required]
            [Priority(10)]
            [Caption("Okres zasiłkowy od")]
            public Date Początek {
                get { return początek; }
                set {
                    początek = value;
                    int delta = początek < new Date(2005, 2, 8) ? 5 : 11;
                    YearMonth to = new YearMonth(początek) - 1;
                    YearMonth from = to - delta;
                    OnChanged(EventArgs.Empty);
                }
            }

            [Browsable(false)]
            public FromTo OkresZasiłkowy {
                get { return new FromTo(początek, Nieobecność.Okres.To); }
            }

            string rachBank;
            [Priority(20)]
            [Caption("Rachunek bankowy")]
            public string RachBank {
                get { return rachBank; }
                set {
                    rachBank = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public object GetListRachBank() {
                List<string> list = new List<string>();

                Soneta.Business.View v = Nieobecność.Pracownik.Rachunki.CreateView();
                v.Sort = "Priorytet";
                foreach (RachunekBankowyPracownika rbp in v)
                    if (!rbp.Blokada)
                        list.Add(rbp.Rachunek.ToString());

                return list;
            }
        }

        PrnParams pars;
        [Soneta.Business.Context(Required = true)]
        public PrnParams Params {
            set {
                pars = value;
                okresZatrudnieniaRok = pars.OkresZatrudnieniaRok();
                okresZasiłkowy = pars.OkresZasiłkowy;
            }
        }
        
        string NBSP(string ss) {
		return ss=="" ? "&nbsp;" : ss;
    }

    string Przekreśl(string tekst) {
        string przekreślOn = "<font style=\"text-decoration: line-through\">";
        string przekreślOff = "</font>";
        return przekreślOn + tekst + przekreślOff;
    }
    
    void LiczDaneFirmy(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string nip = core.Config.Firma.Pieczątka.NIP;
        string regon = core.Config.Firma.Pieczątka.REGON;
        string nazwask = core.Config.Firma.Pieczątka.NazwaSkrócona;
        string nazwisko = core.Config.Firma.DaneEwidencyjne.Nazwisko;
        string imie = core.Config.Firma.DaneEwidencyjne.Imię;
        string kodp = core.Config.Firma.AdresSiedziby.KodPocztowyS;
        string poczta = core.Config.Firma.AdresSiedziby.Poczta;
        string gmina = core.Config.Firma.AdresSiedziby.Gmina;
        string miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        string ulica = core.Config.Firma.AdresSiedziby.Ulica;
        string dom = core.Config.Firma.AdresSiedziby.NrDomu;
        string lokal = core.Config.Firma.AdresSiedziby.NrLokalu;
        string tel = core.Config.Firma.AdresSiedziby.Telefon;
        string symbol = core.Config.Firma.AdresSiedziby.KodKraju;
        string kodz = core.Config.Firma.AdresSiedziby.ZagranicznyKodPocztowy;
        string panstwo = core.Config.Firma.AdresSiedziby.Kraj;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
            if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
            if (!string.IsNullOrEmpty(of.NazwaSkrocona)) nazwask = of.NazwaSkrocona;
            if (!string.IsNullOrEmpty(of.Adres.KodPocztowyS)) kodp = of.Adres.KodPocztowyS;
            if (!string.IsNullOrEmpty(of.Adres.Poczta)) poczta = of.Adres.Poczta;
            if (!string.IsNullOrEmpty(of.Adres.Gmina)) gmina = of.Adres.Gmina;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
            if (!string.IsNullOrEmpty(of.Adres.Ulica)) ulica = of.Adres.Ulica;
            if (!string.IsNullOrEmpty(of.Adres.NrDomu)) dom = of.Adres.NrDomu;
            if (!string.IsNullOrEmpty(of.Adres.NrLokalu)) lokal = of.Adres.NrLokalu;
            if (!string.IsNullOrEmpty(of.Adres.Telefon)) tel = of.Adres.Telefon;
            if (!string.IsNullOrEmpty(of.Adres.KodKraju)) symbol = of.Adres.KodKraju;
            if (!string.IsNullOrEmpty(of.Adres.ZagranicznyKodPocztowy)) kodz = of.Adres.ZagranicznyKodPocztowy;
            if (!string.IsNullOrEmpty(of.Adres.Kraj)) panstwo = of.Adres.Kraj;
        }

        FirmaNIP.EditValue = NBSP(nip.Replace("-", ""));
        FirmaREGON.EditValue = NBSP("");
        FirmaPESEL.EditValue = NBSP("");
        FirmaRodzaj.EditValue = NBSP("");
        FirmaDokument.EditValue = NBSP("");
        if (!string.IsNullOrEmpty(nazwask))
            FirmaNazwa.EditValue = NBSP(nazwask.ToUpper());
        else
            FirmaNazwa.EditValue = NBSP(imie.ToUpper()) + NBSP(nazwisko.ToUpper());
        FirmaKodP.EditValue = NBSP(kodp);
        ///        POCZTA.EditValue = NBSP(poczta);
        ///        GMINA.EditValue = NBSP(gmina);
        FirmaMiejscowosc.EditValue = NBSP(miejscowosc.ToUpper());
        FirmaUlica.EditValue = NBSP(ulica.ToUpper());
        FirmaNrDomu.EditValue = NBSP(dom);
        FirmaNrLokalu.EditValue = NBSP(lokal);
        ///        TEL.EditValue = NBSP(tel);
        ///        SYMBOL.EditValue = NBSP(symbol);
        ///        KODZ.EditValue = NBSP(kodz);
        FirmaKraj.EditValue = NBSP(panstwo.ToUpper());
        ///        MAIL.EditValue = NBSP("");

        if (regon!="")
            FirmaREGON.EditValue = NBSP(regon);
        if (nip=="" || regon=="")
            if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna) {
                string pesel = core.Config.Firma.DaneEwidencyjne.PESEL;
                if (pesel=="") {
                    Wlasciciel wls = DeklaracjeModule.GetInstance(dc).Config.ZUS.Ogólne.DaneWłaściciela;
                    if (wls!=null) {
                        pesel = NBSP(wls.Last.PESEL);
                        if (pesel=="") {
                            FirmaRodzaj.EditValue = NBSP(""); //wls.Last.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty ? "1" : "2");
                            FirmaDokument.EditValue = NBSP(wls.Last.Dokument.SeriaNumer.ToUpper());
                        }
                    }
                }
                if (pesel!="")
                    FirmaPESEL.EditValue = NBSP(pesel);
            }
        string ekd = core.Config.Firma.Pieczątka.EKD;
        string pkd = core.Config.Firma.Pieczątka.PKD;
        EKDPKD.EditValue = ekd + (ekd.Length > 0 && pkd.Length > 0 ? "/" : "") + pkd;
    }
    
    void LiczDanePracownika(PracHistoria ph) {
        PracImie.EditValue = ph.Imie.ToUpper();
        PracNazwisko.EditValue = ph.Nazwisko.ToUpper();

        bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
        if (ph.NIP == "" || ph.PESEL == "") {
            //DOKRODZAJ.EditValue = dowod ? "1" : "2";
            DOKUBEZP.EditValue = ph.Dokument.SeriaNumer.ToUpper();
            
        }
        else {
            //DOKRODZAJ.EditValue = NBSP("");
            DOKUBEZP.EditValue = NBSP("");
            pracPESEL.EditValue = ph.PESEL;
        }

        PracImie1.EditValue = ph.Imie;
        PracNazwisko1.EditValue = ph.Nazwisko;

        if(ph.Etat.KodWykonywanegoZawoduLnk != null && ph.Etat.KodWykonywanegoZawoduLnk.KodGUS != null)
            PracKodGUS.EditValue = ph.Etat.KodWykonywanegoZawoduLnk.KodGUS;

        Date ur = ph.Urodzony.Data;
        ///        if (ur != Date.Empty) URODZONY.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
        IAdres adres = !ph.AdresZamieszkania.IsEmpty() ? ph.AdresZamieszkania : ph.AdresZameldowania;
        AdresKodPocztowyS.EditValue = adres.KodPocztowyS;
        ///        AdresPoczta.EditValue = adres.Poczta;
        ///        AdresGmina.EditValue = adres.Gmina;
        AdresMiejscowosc.EditValue = adres.Miejscowosc.ToUpper();
        AdresUlica.EditValue = adres.Ulica.ToUpper();
        AdresNrDomu.EditValue = adres.NrDomu;
        AdresNrLokalu.EditValue = adres.NrLokalu;
        ///        AdresKodKraju.EditValue = adres.KodKraju;
        ///        AdresZagranicznyKodPocztowy.EditValue = adres.ZagranicznyKodPocztowy;
        AdresKraj.EditValue = adres.Kraj.ToUpper();
        AdresTel.EditValue = ph.Kontakt.TelefonKomorkowy;
        NrRachunku.EditValue = pars.RachBank != null ? pars.RachBank : "&nbsp;";
    }
		
    void OnContextLoad(Object sender, EventArgs args) {
        report = dlTitle;
        dc.LeftMargin = dc.TopMargin = dc.RightMargin = dc.BottomMargin = 19;
        Nieobecnosc nieobecnosc = pars.Nieobecność;
        if (nieobecnosc.Definicja.Typ != TypNieobecnosci.NieobecnośćZUS)
            throw new RowException(nieobecnosc, "Zaświadczenie może być drukowane tylko dla nieobecności ZUS.");
        PracHistoria ph = nieobecnosc.PracHistoria;
        Pracownik pracownik = ph.Pracownik;

        LiczDaneFirmy(ph);
        LiczDanePracownika(ph);
        
        //string strTrwa = "trwa/" + Przekreśl("trwało");
        //string strTrwalo = Przekreśl("trwa") + "/trwało";
        bool wyrejestrowany = ph.Etat.Ubezpieczenia.Chorobowe.Wyrejestrowany;
        UBEZPWYR1.EditValue = wyrejestrowany ? "&nbsp;" : "X";
        UBEZPWYR2.EditValue = wyrejestrowany ? "X" : "&nbsp;";
        //UbezpWyrejestr.EditValue = wyrejestrowany ? strTrwalo : strTrwa;
        //if (wyrejestrowany)
        //    UbezpWyrData.EditValue = "<strong>" + ph.Etat.Ubezpieczenia.Chorobowe.Do + "</strong>";
        //else
        //    UbezpWyrData.EditValue = ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .";
        UBEZPWYR3.EditValue = wyrejestrowany ? ph.Etat.Ubezpieczenia.Chorobowe.Do.ToString() : "&nbsp;";

        LiczWynagrodzeniaZasiłki(pracownik);
    }

    string KodLiterowy(WypElement e) {
        WypElementNieobecność en = e as WypElementNieobecność;
        string kod = "";
        if (en != null && en.Nieobecność != null && en.Nieobecność.Zwolnienie.KodChoroby != "")
            kod = en.Nieobecność.Zwolnienie.KodChoroby;
        return kod;
    }
    
    string GetElementyInfo(ICollection<WypElement> elementy) {
        if (elementy.Count == 0)
            return "";

        Dictionary<FromTo, string> okresy = new Dictionary<FromTo, string>();
        Dictionary<FromTo, int> hash = new Dictionary<FromTo, int>();
        int storno, ilosc;
        string kod;

        foreach (WypElement e in elementy) {
            storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
            if (hash.TryGetValue(e.Okres, out ilosc))
                hash[e.Okres] = ilosc + storno;
            else
                hash.Add(e.Okres, storno);
            if (!okresy.TryGetValue(e.Okres, out kod))
                okresy.Add(e.Okres, KodLiterowy(e));
            else if (kod == "")
                okresy[e.Okres] = KodLiterowy(e);
        }

        string result = "";
        foreach (FromTo ft in okresy.Keys) {
            if (hash[ft] <= 0)
                continue;
            //kod = okresy[ft];
            //if (kod == "") kod = "...........";
            string line = string.Format("od {0} do {1}<br/>", ft.From, ft.To);
            result += line;
        }

        return result;
    }

    FromTo okresZatrudnieniaRok = FromTo.Empty;
    FromTo okresZasiłkowy = FromTo.Empty;

    void LiczWynagrodzeniaZasiłki(Pracownik pracownik) {
        List<WypElement> wynagrodzania = new List<WypElement>();
        List<WypElement> zasiłki = new List<WypElement>();
        List<FromTo> okresy = new List<FromTo>();
        
        SubTable st = PlaceModule.GetInstance(dc).WypElementy.WgPracownik[pracownik];
        st = new SubTable(st, okresZatrudnieniaRok);
        foreach (WypElement e in st) {
            try {
                KodRSA kod = e.KodRSA;
                if (kod != null && kod.WynagrodzenieChorobowe) {
                    wynagrodzania.Add(e);
                    okresy.Add(e.Okres);
                }
                else if (e.ZasiłekZus /*&& e.Wartosc != 0*/ && okresZasiłkowy.IsIntersected(e.Okres)) {
                    zasiłki.Add(e);
                    okresy.Add(e.Okres);
                    WypElementNieobecność en = e as WypElementNieobecność;
                    Nieobecnosc ni = en == null ? null : en.Nieobecność;
                    if (ni != null)
                        switch (ni.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                                zasiłki.Remove(e);
                                okresy.Remove(e.Okres);
                                break;
                        }
                }
            }
            catch { Msg(); }
        }

        Date start = zasiłki.Count == 0 ? Date.MaxValue : zasiłki[0].Okres.From;
        if (wynagrodzania.Count > 0 && wynagrodzania[0].Okres.From < start)
            start = wynagrodzania[0].Okres.From;

        //TID: 10790
        //Cofamy się po 61 dni w poszukiwaniu zasiłków/wynagrodzeń
        //Jak znajdziemy jakiekolwiek, to cofamy się dalej, a wynagrodzenia dodajemy do listy                
        while (true) {
            FromTo okres = new FromTo(start - 61, start - 1);

            st = PlaceModule.GetInstance(dc).WypElementy.WgPracownik[pracownik];
            st = new SubTable(st, okres);
            bool any = false;
            foreach (WypElement e in st) {
                try {
                    KodRSA kod = e.KodRSA;
                    bool ok = false;
                    if (kod != null && kod.WynagrodzenieChorobowe) {
                        wynagrodzania.Add(e);
                        ok = true;
                    }
                    else if (e.ZasiłekZus /*&& e.Wartosc != 0*/ && okresZasiłkowy.IsIntersected(e.Okres)) {
                        zasiłki.Add(e);
                        ok = true;
                        WypElementNieobecność en = e as WypElementNieobecność;
                        Nieobecnosc ni = en == null ? null : en.Nieobecność;
                        if (ni != null)
                            switch (ni.Definicja.Przyczyna) {
                                case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                                    zasiłki.Remove(e);
                                    break;
                            }
                    }

                    if (!any && ok) {
                        any = true;
                        start = e.Okres.From;
                    }
                }
                catch { Msg(); }
            }
            if (!any)
                break;
        }

        wynagrodzania.Sort(delegate(WypElement a, WypElement b) { return a.Okres.From.CompareTo(b.Okres.From); });
        okresy.Sort(delegate(FromTo a, FromTo b) { return a.From.CompareTo(b.From); });
        
        NIEZDOLNYOD.EditValue = start == Date.MaxValue ? "&nbsp;" : start.ToString();
        
        wynagrodzania.Sort();
        string wyn = GetElementyInfo(wynagrodzania);
        JESTWYN.EditValue = wyn != "" ? "X" : "&nbsp;";
        WYNAGRODZENIA.EditValue = wyn;

        zasiłki.Sort();
        string zas = GetElementyInfo(zasiłki);
        JESTZAS.EditValue = zas != "" ? "X" : "&nbsp;";
        ZASILKI.EditValue = zas;

        KoniecOkresuZasilkowego(okresy);
    }

    void KoniecOkresuZasilkowego(List<FromTo> okresy) {
        Nieobecnosc nieobecność = pars.Nieobecność;
        Date dataNiePłacimy = Date.Empty;
        string koniecOkresu = "";
        
        if (nieobecność.Definicja != null && nieobecność.Okres != FromTo.Empty)
            if (nieobecność.Definicja.Rozliczenie == RozliczenieNieobecnosci.JakZwolnienieChorobowe)
                foreach (FromTo okres in Periods.New(nieobecność.Okres).BreakByYear()) {
                    CięcieChorobowego cięcie = new CięcieChorobowego(nieobecność, okres);
                    cięcie.Tnij(Periods.Empty);
                    dataNiePłacimy = cięcie.DataNiePłacimy;
                    if (okres.Contains(dataNiePłacimy)) {
                        koniecOkresu = dataNiePłacimy.ToString();
                        break;
                    }
                }
        ZASILKIKONIEC.EditValue = koniecOkresu.Length == 0 ? "&nbsp;" : koniecOkresu;
        
        ZASILKIDNI1.EditValue = "&nbsp;";
        ZASILKIDNI2.EditValue = "&nbsp;";
        if (koniecOkresu.Length != 0) {
            FromTo ftn = new FromTo(nieobecność.Okres.From, nieobecność.Okres.From>=dataNiePłacimy ? nieobecność.Okres.From : dataNiePłacimy.AddDays(-1));
            int days = 0;
            foreach (FromTo ft in okresy) {
                if (ft.IsIntersected(ftn))
                    break;
                days += ft.Days;
            }
            days += ftn.Days;
            if (days >= 182 && days < 270)
                ZASILKIDNI1.EditValue = "X";
            else
                ZASILKIDNI2.EditValue = "X";
        }
    }
   
    public static void Msg(object obj) {
    }

    public static DataLabel report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (!report.EditValue.ToString().Contains(msg))
            report.EditValue = msg;
    }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Tahoma">
		<form id="DeklaracjaNP7" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.KadryPlace"></ea:datacontext>

            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
			    ResetPageCounter="True"></ea:PageBreak>
            <ea:Section runat="server" SectionType="Header"></ea:Section>
            <ea:Section runat="server" SectionType="Body">

            <p align="right">
                <b>ZNp-7</b>
            </p>

            <p align="center">
                <b>WNIOSEK<br />O ŚWIADCZENIE REHABILITACYJNE</b><br />
                <ea:datalabel id="dlTitle" runat="server" Bold="false"></ea:datalabel>
            </p>

            <font face="Tahoma" size="2">
                <p style="text-align:left">
                    <u><b>Instrukcja wypełniania</b></u><br />
                </p>
                Świadczenie rehabilitacyjne przysługuje ubezpieczonemu, który po wyczerpaniu okresu pobierania zasiłku chorobowego
                jest nadal niezdolny do pracy, a dalsze leczenie lub rehabilitacja rokują odzyskanie zdolności do pracy<br />
                Wypełnij CZĘŚĆ I wniosku.<br />
                CZĘŚĆ II wniosku wypełnia płatnik składek.<br />
                <ol>
                    <li>Wypełnij WIELKIMI LITERAMI</li>
                    <li>Pola wyboru zaznacz znakiem <b>X</b></li>
                    <li>Wypełnij kolorem czarnym lub niebieskim (nie ołówkiem)</li>
                    <li>We wniosku podaj adres zamieszkania</li>
                    <li>Zanim wypełnisz wniosek, zapoznaj się z <b>Pouczeniem</b></li>
                </ol>
            </font>

            <font face="Tahoma" size="2">
                <u><b>Dane wnioskodawcy</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="pracPESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="PracImie" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="PracNazwisko" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Ulica</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer domu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKodPocztowyS" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Miejscowość</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
						    <FONT size="2"><ea:DataLabel ID="AdresMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa państwa</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer telefonu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresTel" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj numer telefonu – to ułatwi nam kontakt w Twojej sprawie</i></FONT>
						</TD>
					</TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
                <u><b>CZĘŚĆ I. (wypełnij tę część wniosku)</b></u><br/>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Oświadczenie</b></u><br/>
                <font face="Tahoma" size="1">
                    <i>Ubiegam się o świadczenie rehabilitacyjne w związku z niezdolnością do pracy spowodowaną</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="30%">
                            <FONT size="2">[ ] ogólnym stanem zdrowia</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="30%">
                            <FONT size="2">[ ] wypadkiem przy pracy</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="30%">
                            <FONT size="2">[ ] chorobą zawodową</FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Informacje</b></u>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">1. Czy masz ustalone prawo do</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="50%">
                            <FONT size="2">[ ] emerytury</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] renty z tytułu niezdolności do pracy</FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="50%">
                            <FONT size="2">[ ] wojskowej renty inwalidzkiej</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] renty z tytułu niezdolności do służby</FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="50%">
                            <FONT size="2">[ ] nauczycielskiego świadczenia kompensacyjnego</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="45%"></TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="8%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="8%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="74%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="74%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj symbol i numer świadczenia oraz kto wypłaca</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">2. Czy masz ustalone prawo do zagranicznej emerytury lub zagranicznej renty z tytułu niezdolności do pracy</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="8%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="8%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="74%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="74%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj przez kogo zostało ustalone prawo oraz od kiedy zostało przyznane (dd/mm/rrrr)</i></FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak6" runat="server" Required="True"></ea:PageBreak>

            <font face="Tahoma" size="2">
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">3. Czy złożyłeś wniosek o</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] emeryturę</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] rentę z tytułu niezdolności do pracy</FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] wojskową rentę inwalidzką</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] rentę z tytułu niezdolności do służby</FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] nauczycielskie świadczenie kompensacyjne</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%"></TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="60%" border="0">
					<TR>
						<TD width="12%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="12%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="66%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="12%"></TD>
						<TD width="5%"></TD>
						<TD width="12%"></TD>
						<TD width="5%"></TD>
						<TD width="66%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj datę złożenia wniosku (dd/mm/rrrr)</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">4. Czy jesteś uprawniony do</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="30%">
                            <FONT size="2">[ ] zasiłku dla bezrobotnych</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="30%">
                            <FONT size="2">[ ] zasiłku przedemerytalnego</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="36%">
                            <FONT size="2">[ ] świadczenia przedemerytalnego</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="8%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="8%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="74%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="74%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okres od–do</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">5. Czy jesteś uprawniony do urlopu dla poratowania zdrowia na podstawie odrębnych przepisów</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="8%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="8%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="74%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="8%"></TD>
						<TD width="5%"></TD>
						<TD width="74%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okres od–do</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
            </font>
            <br />

            <font face="Tahoma" size="2">
                <u><b>Rachunek bankowy</b></u><br/>
                <font face="Tahoma" size="1">
                    <i>Podaj swój rachunek bankowy, na który mamy przekazywać świadczenie rehabilitacyjne</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="NrRachunku" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
				</TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
                <b>Oświadczam, że dane zawarte we wniosku podałem zgodnie z prawdą.
                Jeżeli ulegną one zmianie, zobowiązuję się poinformować o nich płatnika zasiłku.</b><br/>
            </font>
            <br />

			<TABLE cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="45%" align="center" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT size="1"><br /><br />.......................................................<br />Data: dd/mm/rrrr</FONT>
                    </TD>
                    <TD width="10%"></TD>
					<TD width="45%" align="center" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT size="1"><br /><br />.......................................................<br />Czytelny podpis</FONT>
                    </TD>
                </TR>
			</TABLE>

			<ea:PageBreak id="PageBreak12" runat="server" Required="True"></ea:PageBreak>

            <p align="right">
                <b>ZNp-7</b>
            </p>

            <font face="Tahoma" size="2">
                <u><b>CZĘŚĆ II. Informacje o ubezpieczeniu i niezdolności do pracy (wypełnia płatnik składek)</b></u><br/>
            </font>
            <br />

            <font face="Tahoma" size="2">
                <u><b>Dane płatnika składek</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">NIP</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNIP" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer REGON</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaREGON" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie podałeś NIP, podaj REGON</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaPESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie masz nadanego NIP i REGON, podaj PESEL</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="FirmaRodzaj" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="FirmaDokument" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie masz nadanego NIP, REGON i PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa albo imię i nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNazwa" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Ulica</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer domu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaKodP" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Miejscowość</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
						    <FONT size="2"><ea:DataLabel ID="FirmaMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa państwa</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Podaj symbol EKD/ PKD</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="EKDPKD" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Informacje o ubezpieczonym</b></u><br/>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="30%">
                            <FONT size="2">1. Czy ubezpieczenie</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="65%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
				                <ea:DataLabel id="PracImie1" runat="server"></ea:DataLabel>
				                <ea:DataLabel id="PracNazwisko1" runat="server"></ea:DataLabel>
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="30%"></TD>
						<TD width="5%"></TD>
						<TD width="65%">
                            <FONT size="1"><i>Podaj imię i nazwisko ubezpieczonego</i></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="30%">
                            <FONT size="2">
                                [<ea:DataLabel id="UBEZPWYR1" runat="server"></ea:DataLabel>] trwa
                            </FONT>
						</TD>
						<TD width="5%"></TD>
						<TD width="65%"></TD>
                    </TR>
					<TR>
						<TD width="30%"><br /></TD>
						<TD width="5%"><br /></TD>
						<TD width="65%"><br /></TD>
                    </TR>
					<TR>
						<TD width="30%">
                            <FONT size="2">
                                [<ea:DataLabel id="UBEZPWYR2" runat="server"></ea:DataLabel>] trwało do
                            </FONT>
						</TD>
						<TD width="5%"></TD>
						<TD width="65%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel id="UBEZPWYR3" runat="server"></ea:DataLabel><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="30%"></TD>
						<TD width="5%"></TD>
						<TD width="65%">
                            <FONT size="1"><i>Podaj datę do kiedy trwało (dd/mm/rrrr)</i></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="30%">
                            <FONT size="2">2. Kod zawodu</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="65%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
				                <ea:DataLabel runat="server" ID="PracKodGUS"></ea:DataLabel><br />
                            </FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Informacje o wypłaconych świadczeniach</b></u><br/>
                <font face="Tahoma" size="1">
                    <i>Wypełnij tę część jeśli wypłacasz zasiłek chorobowy</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="58%">
                            <FONT size="2">1. Ubezpieczony jest niezdolny do pracy z powodu choroby od</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="40%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
				                <ea:DataLabel id="NIEZDOLNYOD" runat="server"></ea:DataLabel><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="58%"></TD>
						<TD width="2%"></TD>
						<TD width="40%">
                            <FONT size="1"><i>Podaj datę (dd/mm/rrrr)</i></FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">2. W okresie niezdolności do pracy ubezpieczony otrzymał</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="58%">
                            <FONT size="2">
                                [<ea:DataLabel id="JESTWYN" runat="server"></ea:DataLabel>] wynagrodzenie za okres niezdolności do pracy
                            </FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="40%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel id="WYNAGRODZENIA" runat="server"></ea:DataLabel><br />
                                <br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="58%"></TD>
						<TD width="2%"></TD>
						<TD width="40%">
                            <FONT size="1"><i>Podaj okresy od–do</i></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="58%">
                            <FONT size="2">
                                [<ea:DataLabel id="JESTZAS" runat="server"></ea:DataLabel>] zasiłek chorobowy
                            </FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="40%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel id="ZASILKI" runat="server"></ea:DataLabel><br />
                                <br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="58%"></TD>
						<TD width="2%"></TD>
						<TD width="40%">
                            <FONT size="1"><i>Podaj okresy od–do</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="38%">
                            <FONT size="2">3. Okres zasiłkowy zakończy się z dniem</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel id="ZASILKIKONIEC" runat="server"></ea:DataLabel>
                            </FONT>
						</TD>
						<TD width="8%">
                            <FONT size="2">&nbsp;&nbsp;&nbsp;&nbsp;po</FONT>
						</TD>
						<TD width="15%">
                            <FONT size="2">
                                [<ea:DataLabel id="ZASILKIDNI1" runat="server"></ea:DataLabel>] 182 dniach
                            </FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="15%">
                            <FONT size="2">
                                [<ea:DataLabel id="ZASILKIDNI2" runat="server"></ea:DataLabel>] 270 dniach
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="38%"></TD>
						<TD width="2%"></TD>
						<TD width="20%">
                            <FONT size="1"><i>Podaj datę (dd/mm/rrrr)</i></FONT>
						</TD>
						<TD width="8%"></TD>
						<TD width="15%"></TD>
						<TD width="2%"></TD>
						<TD width="15%"></TD>
                    </TR>
                </TABLE>
            </font>
            <br />

			<TABLE cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="30%" align="center" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT size="1"><br /><br />.......................................................<br />Data: dd/mm/rrrr</FONT>
                    </TD>
                    <TD width="5%"></TD>
					<TD width="30%" align="center" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT size="1"><br /><br />.......................................................<br />Podpis upoważnionego pracownika, nr telefonu oraz pieczątka zawierająca imię, nazwisko i stanowisko</FONT>
                    </TD>
                    <TD width="5%"></TD>
					<TD width="30%" align="center" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT size="1"><br /><br />.......................................................<br />Pieczątka płatnika składek, jeśli ją posiadasz</FONT>
                    </TD>
                </TR>
			</TABLE>
            <br /><br /><br /><br />

			<ea:PageBreak id="PageBreak2" runat="server" Required="True"></ea:PageBreak>

            <p align="right">
                <b>ZNp-7</b>
            </p>

			<P style="text-align: center"><FONT size="2"><strong>POUCZENIE</strong></FONT></P>
            <p style="text-align: left">
                <font size="2">
                    <b><i>Przez jaki okres przysługuje świadczenie rehabilitacyjne.</i></b><br />
                    Świadczenie rehabilitacyjne przysługuje przez okres niezbędny do przywrócenia zdolności do pracy, nie dłużej niż przez 12 miesięcy (360 dni).<br /><br />
                    <b><i>Okoliczności, które pozbawiają prawa do świadczenia rehabilitacyjnego</i></b><br />
                    Świadczenie rehabilitacyjne nie przysługuje, jeśli:<br />
                    &nbsp;* jesteś uprawniony do emerytury, renty z tytułu niezdolności do pracy, zasiłku dla bezrobotnych, zasiłku przedemerytalnego, świadczenia przedemerytalnego, nauczycielskiego świadczenia kompensacyjnego oraz urlopu dla poratowania zdrowia, udzielonego na podstawie odrębnych przepisów,<br />
                    &nbsp;* przebywasz w areszcie tymczasowym lub odbywasz karę pozbawienia wolności,<br />
                    &nbsp;* korzystasz z urlopu bezpłatnego lub wychowawczego,<br />
                    &nbsp;* wykonujesz w okresie pobierania świadczenia rehabilitacyjnego pracę zarobkową bądź wykorzystujesz świadczenie rehabilitacyjne niezgodnie z jego celem.<br />
                    <br />
                    <b><i>Niezbędne dokumenty</i></b><br />
                    Do wniosku dołącz:<br />
                    &nbsp;* zaświadczenie o stanie zdrowia (druk OL-9) wypełnione przez lekarza leczącego nie wcześniej niż na miesiąc przed datą kiedy składasz wniosek,<br />
                    &nbsp;* wywiad zawodowy z miejsca pracy (druk OL-10) – ten druk nie jest wymagany, jeżeli wniosek składa osoba, której niezdolność do pracy powstała po ustaniu ubezpieczenia albo osoba prowadząca pozarolniczą działalność,<br />
                    &nbsp;* protokół ustalenia okoliczności i przyczyn wypadku przy pracy lub kartę wypadku, jeżeli niezdolność do pracy została spowodowana wypadkiem przy pracy,<br />
                    &nbsp;* decyzję o stwierdzeniu choroby zawodowej – jeśli niezdolność do pracy ma związek z chorobą zawodową Nie musisz składać dokumentacji wypadkowej oraz decyzji o stwierdzeniu choroby zawodowej, jeśli dokumenty te złożyłeś w ZUS wcześniej np. gdy składałeś wniosek o zasiłek chorobowy.<br />
                    &nbsp;* jeżeli świadczenie rehabilitacyjne wypłaca ZUS – zaświadczenie płatnika składek:<br />
                    &nbsp;&nbsp;- Z-3 – w przypadku pracowników,<br />
                    &nbsp;&nbsp;- Z-3b – w przypadku ubezpieczonych prowadzących pozarolniczą działalność, ubezpieczonych współpracujących z osobami prowadzącymi pozarolniczą działalność oraz duchownych,<br />
                    &nbsp;&nbsp;- Z-3a – w przypadku pozostałych ubezpieczonych.<br />
                </font>
            </p>
            <p style="text-align: justify">
                <font size="2">
                    <b>Zaświadczenie płatnika składek nie jest wymagane, jeżeli było złożone do ustalenia prawa do zasiłku chorobowego i nie uległy zmianie okoliczności, które mają wpływ na prawo, wysokość i podstawę wymiaru świadczenia.<br /><br /> 
                    Ważne!<br />
                    Wniosek z kompletną dokumentacją złóż w placówce ZUS najbliższej Twojego miejsca zamieszkania, co najmniej na 6 tygodni przed zakończeniem pełnego (182 dni, 270 dni) okresu zasiłkowego.<br />
                    CZĘŚCI II nie wypełnia się, jeśli ubiegasz się o przyznanie świadczenia rehabilitacyjnego na kolejny okres, po wyczerpaniu okresu pobierania świadczenia rehabilitacyjnego krótszego niż 12 miesięcy.<br /><br />
                    Podstawa prawna: ustawa z dnia 25 czerwca 1999 r. o świadczeniach pieniężnych z ubezpieczenia społecznego w razie choroby i macierzyństwa, ustawa z dnia 30 października 2002 r. o ubezpieczeniu społecznym z tytułu wypadków przy pracy i chorób zawodowych oraz rozporządzenie Ministra Rodziny, Pracy i Polityki Społecznej z 8 grudnia 2015 r. w sprawie zakresu informacji o okolicznościach mających wpływ na prawo do zasiłków z ubezpieczenia społecznego w razie choroby i macierzyństwa lub ich wysokość oraz dokumentów niezbędnych do przyznania i wypłaty zasiłków.</b>
                </font>
            </p>
            </ea:Section>
		    <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="GlobalFooter"></ea:SectionMarker>
		</form>
	</body>
</HTML>
